program Atrybuty1;

uses
  RTTI, System.SysUtils, TypInfo;

type
  // Definicja prostego atrybutu
  ProstyAtrybut = class(TCustomAttribute)
  private
    FLiczba: integer;
  public
    constructor Create(aLiczba: integer);
    property Liczba: integer read FLiczba;
  end;

constructor ProstyAtrybut.Create(aLiczba: integer);
begin
  FLiczba := aLiczba;
end;

type
  TAtrybutWłaściwości = class
  private
    function WeźButelkęPiwa: string;
  public
    [ProstyAtrybut(99)] // Atrybut właściwości
    property ButelkaPiwa: string read WeźButelkęPiwa;
    function PodajAtrybutWłaściwości: string;
  end;

function TAtrybutWłaściwości.WeźButelkęPiwa: string;
begin
end;

function TAtrybutWłaściwości.PodajAtrybutWłaściwości: string;
var
  Kontekst: TRttiContext;
  TypTymcz: TRttiType;
  WłaściwośćTymcz: TRttiProperty;
  AtrybutyTymcz: TArray<TCustomAttribute>;
  WartośćTymcz: TValue;
  Atrybut: TCustomAttribute;
begin
  Result := '';
  TypTymcz := Kontekst.GetType(Self.ClassType);
  WłaściwośćTymcz := TypTymcz.GetProperty('ButelkaPiwa');
  AtrybutyTymcz := WłaściwośćTymcz.GetAttributes;
  for Atrybut in AtrybutyTymcz do
  begin
    if Atrybut is ProstyAtrybut then
    begin
      WartośćTymcz := ProstyAtrybut(Atrybut).Liczba;
    end;
  end;
  Result := WartośćTymcz.ToString;
end;

var
  AW: TAtrybutWłaściwości;
begin
  AW := TAtrybutWłaściwości.Create;

  WriteLn(AW.PodajAtrybutWłaściwości);
  ReadLn;
end.
